

#include <stdint.h>

#define NULL ((void *)0)
#define MAX_MEMORY_POOL_COUNT	2

typedef struct mem_entry_t
{
	uint32_t size;
	struct mem_entry_t * prevEntry;
} raw_mem_entry_t;

typedef struct
{
	uint32_t startAddress;
	uint32_t endAddress;
	raw_mem_entry_t * lastEntry;
} raw_mem_pool_t;

raw_mem_pool_t memoryPools[MAX_MEMORY_POOL_COUNT];
uint8_t memPoolCount = 0;

int8_t memory_pool_create(uint32_t startAddr, uint32_t endAddr)
{
	raw_mem_pool_t * memPool = NULL;

	if (memPoolCount >= MAX_MEMORY_POOL_COUNT)
	{
		return -1;
	}
	
	memPool = &memoryPools[memPoolCount];
	memPool->startAddress = startAddr;
	memPool->endAddress = endAddr;
	memPool->lastEntry = NULL;
	
	return memPoolCount++;
} 

void memory_pool_destroy_all(void)
{
	memPoolCount = 0;
}

void * memory_pool_allocate(int8_t poolId, uint32_t size, int32_t alignment)
{
	uint32_t startAddress;
	uint32_t offset = 0;
	raw_mem_pool_t * memPool;
	raw_mem_entry_t * memEntry;

	/* The memory pool ID must be valid */
	if (poolId >= memPoolCount)
	{
		return NULL;
	}

	memPool = &memoryPools[poolId];
	
	/* Get the starting address of the new memory block (including meta-data) */
	startAddress = (memPool->lastEntry == NULL)? 
		memPool->startAddress : 
		((uint32_t)memPool->lastEntry) + sizeof(raw_mem_entry_t) + memPool->lastEntry->size;
		
	startAddress += sizeof(raw_mem_entry_t);
	
	/* Ensure the user memory block is alligned, if necessary */
	if ((alignment > 0) && (startAddress % alignment != 0))
	{
		offset = alignment - (startAddress % alignment);
	}
	
	size += offset;
	
	if (startAddress + size > memPool->endAddress)
	{
		return NULL;
	}
	
	/* Register the new memory block */
	memEntry = (raw_mem_entry_t *)(startAddress - sizeof(raw_mem_entry_t));
	memEntry->prevEntry = memPool->lastEntry;
	memPool->lastEntry = memEntry;
	memEntry->size = size;
	
	return (void *)(startAddress + offset);
}

void memory_pool_free(int8_t poolId, void * ptr)
{
          raw_mem_pool_t * memPool;
          memPool = &memoryPools[poolId];
          memPool->lastEntry = memPool->lastEntry->prevEntry; 
          
  /* Not implemented */
}
